/*
 * Decompiled with CFR 0.152.
 */
package com.james.tinkerscalibration.modifiers;

import java.util.UUID;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;

public class ArmorDominateModifier
extends Modifier {
    private final ResourceLocation KEY = new ResourceLocation("tinkerscalibration", "dominate_armor");

    public void onInventoryTick(@Nonnull IToolStackView tool, int level, @Nonnull Level world, @Nonnull LivingEntity holder, int itemSlot, boolean isSelected, boolean isCorrectSlot, ItemStack stack) {
        ModDataNBT persistantData = tool.getPersistentData();
        if (!world.f_46443_) {
            persistantData.putFloat(this.KEY, holder.m_21223_());
        }
    }

    public void onRemoved(IToolStackView tool) {
        tool.getPersistentData().remove((ResourceLocation)this.getId());
    }

    public boolean isArmor(EquipmentSlot slot) {
        return slot == EquipmentSlot.HEAD || slot == EquipmentSlot.CHEST || slot == EquipmentSlot.LEGS || slot == EquipmentSlot.FEET;
    }

    public void addAttributes(IToolStackView tool, int level, EquipmentSlot slot, BiConsumer<Attribute, AttributeModifier> consumer) {
        ModDataNBT persistentData;
        float value;
        if (this.isArmor(slot) && (value = (persistentData = tool.getPersistentData()).getFloat(this.KEY)) != 0.0f) {
            consumer.accept(Attributes.f_22281_, new AttributeModifier(UUID.fromString("ead86e6d-75d7-440f-acae-159b530f5eee"), Attributes.f_22281_.m_22087_(), Math.cbrt(value), AttributeModifier.Operation.ADDITION));
        }
    }
}

